export interface DebugPingResponse {
  status: string;
  timestamp: number;
}

export interface SupabaseConnectionTest {
  connected: boolean;
  tables: string[];
  error?: string;
}

export interface UserDebugInfo {
  user_id: string;
  email: string;
  role: string;
  vendor?: {
    id: string;
    name: string;
    status: string;
  };
  subscription?: {
    plan: string;
    status: string;
    trial_end?: string;
  };
  features: string[];
  trial_state: {
    is_trial: boolean;
    days_remaining: number;
  };
}

export interface FeatureCheckRequest {
  user_id: string;
  feature: string;
}

export interface FeatureCheckResponse {
  enabled: boolean;
  source: 'plan' | 'trial' | 'admin_override';
  plan?: string;
  trial_days_remaining?: number;
}

export interface SubscriptionCheckRequest {
  vendor_id: string;
}

export interface SubscriptionCheckResponse {
  vendor_id: string;
  plan: string;
  status: string;
  trial: {
    is_trial: boolean;
    days_remaining: number;
  };
  features: string[];
  limits: {
    websites?: number;
    products?: number;
    edits?: number;
  };
}

export interface AILogRequest {
  message: string;
  source_module: string;
  user_id?: string;
}

export interface AILogResponse {
  ai_response: string;
  trace_id: string;
  latency: number;
  success: boolean;
  error?: string;
}

export interface SystemStatus {
  api: {
    status: 'healthy' | 'degraded' | 'down';
    response_time: number;
  };
  supabase: {
    status: 'connected' | 'disconnected' | 'error';
    tables_accessible: number;
  };
  ai_service: {
    status: 'available' | 'unavailable' | 'error';
    response_time: number;
  };
  feature_gates: {
    status: 'working' | 'error';
    cached_features: number;
  };
  queue: {
    status: 'idle' | 'processing' | 'error';
    pending_jobs: number;
  };
  overall_status: 'healthy' | 'degraded' | 'down';
  timestamp: string;
}

export interface CacheDebugInfo {
  user_id: string;
  cached_features: string[];
  cache_timestamp: string;
  cache_ttl: number;
}

export interface DebugLogEntry {
  id?: string;
  user_id?: string;
  action: string;
  module: string;
  details: any;
  timestamp?: string;
}

export interface ApiResponse<T = any> {
  success: boolean;
  data?: T;
  error?: string;
} 